#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
using namespace std;

struct Tacka {
    int x, y;
};

int orijentacija(const Tacka& p, const Tacka& q, const Tacka& r) {
    return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
}

vector<Tacka> konveksniOmotac(vector<Tacka>& tacke) {
    int n = tacke.size();
    if (n < 3) return tacke;

    sort(tacke.begin(), tacke.end(), [](const Tacka& a, const Tacka& b) {
        return (a.x < b.x) || (a.x == b.x && a.y < b.y);
    });

    vector<Tacka> omotac;

    for (const auto& t : tacke) {
        while (omotac.size() >= 2 && orijentacija(omotac[omotac.size() - 2], omotac.back(), t) <= 0) {
            omotac.pop_back();
        }
        omotac.push_back(t);
    }

    int k = omotac.size();
    for (int i = n - 1; i >= 0; i--) {
        while (omotac.size() > k && orijentacija(omotac[omotac.size() - 2], omotac.back(), tacke[i]) <= 0) {
            omotac.pop_back();
        }
        omotac.push_back(tacke[i]);
    }

    omotac.pop_back();
    return omotac;
}

double povrsina(const vector<Tacka>& omotac) {
    int n = omotac.size();
    double pov = 0;
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        pov += omotac[i].x * omotac[j].y - omotac[i].y * omotac[j].x;
    }
    return abs(pov) / 2.0;
}

int main() {
    int N;
    cin >> N;
    vector<Tacka> tacke(N);

    for (int i = 0; i < N; i++) {
        cin >> tacke[i].x >> tacke[i].y;
    }

    double minimalnaPovrsina = 1e18;

    for (int i = 0; i < N; i++) {
        vector<Tacka> preostale;
        for (int j = 0; j < N; j++) {
            if (i != j) {
                preostale.push_back(tacke[j]);
            }
        }

        vector<Tacka> skoroOmotac = konveksniOmotac(preostale);
        minimalnaPovrsina = min(minimalnaPovrsina, povrsina(skoroOmotac));
    }

    cout << static_cast<int>(round(minimalnaPovrsina)) << endl;
    return 0;
}